// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma once
#endif
#ifndef MIDDLEWARENEWSBRIEF_DDSUTILS_DDSUTIL_H
#define MIDDLEWARENEWSBRIEF_DDSUTILS_DDSUTIL_H

#include "DDSTypeDetails_T.h"
#include "MiddlewareNewsBrief_DdsUtil_Export.h"

// OpenDDS
#include <dds/DCPS/Service_Participant.h>
#include <dds/DCPS/SubscriberImpl.h>
#include <dds/DCPS/PublisherImpl.h>

#include <sstream>
#include <stdexcept>

namespace MiddlewareNewsBrief {

    template <typename DDS_STRUCT_T> struct DDSTypeDetails;

    class MiddlewareNewsBrief_DdsUtil_Export DDSUtil
    {
    public:
      static
      DDS::Subscriber_ptr
        create_subscriber(DDS::DomainParticipant_ptr participant,
                          const int transport_impl_id,
                          const char* partition = 0);
      
      static
      DDS::Publisher_ptr
        create_publisher(DDS::DomainParticipant_ptr participant,
                         const int transport_impl_id,
                         const char* partition = 0);
      
      static
      DDS::DataReader_ptr
        create_datareader(DDS::DomainParticipant_ptr participant,
                          DDS::Subscriber_ptr subscriber,
                          std::string topic_name,
                          const std::string& type_name,
                          DDS::DataReaderListener_ptr listener);

      static
      DDS::DataWriter_ptr
        create_datawriter(DDS::DomainParticipant_ptr participant,
                          DDS::Publisher_ptr publisher,
                          std::string topic_name,
                          const std::string& type_name);

      template <typename TYPE_SUPPORT_IMPL_T>
      static
      DDS::DataReader_ptr
        create_datareader(DDS::DomainParticipant_ptr participant,
                          DDS::Subscriber_ptr subscriber,
                          const std::string& topic_name,
                          DDS::DataReaderListener_ptr listener);

      template <typename TYPE_SUPPORT_IMPL_T>
      static
      DDS::DataWriter_ptr
        create_datawriter(DDS::DomainParticipant_ptr participant,
                          DDS::Publisher_ptr publisher,
                          const std::string& topic_name);
    };

    template <typename TYPE_SUPPORT_IMPL_T>
    DDS::DataReader_ptr
    DDSUtil::create_datareader(DDS::DomainParticipant_ptr participant,
                               DDS::Subscriber_ptr subscriber,
                               const std::string& topic_name,
                               DDS::DataReaderListener_ptr listener)
    {
      TYPE_SUPPORT_IMPL_T* ts = new TYPE_SUPPORT_IMPL_T();
      std::string type_name = ts->get_type_name();
      DDS::ReturnCode_t retcode =
        ts->register_type(participant,type_name.c_str());
      ts->_remove_ref();
      if (DDS::RETCODE_OK != retcode)
      {
        std::ostringstream msg;
        msg << "register_type for "
            << type_name.c_str() << " failed." << std::ends;
        throw std::runtime_error(msg.str());
      }
      
      return create_datareader(participant,
                               subscriber,
                               topic_name,
                               type_name,
                               listener);
    }

    template <typename TYPE_SUPPORT_IMPL_T>
    DDS::DataWriter_ptr
    DDSUtil::create_datawriter(DDS::DomainParticipant_ptr participant,
                               DDS::Publisher_ptr publisher,
                               const std::string& topic_name)
    {
      TYPE_SUPPORT_IMPL_T* ts = new TYPE_SUPPORT_IMPL_T();
      std::string type_name = ts->get_type_name();
      DDS::ReturnCode_t retcode =
        ts->register_type(participant,type_name.c_str());
      ts->_remove_ref();
      if (DDS::RETCODE_OK != retcode)
      {
        std::ostringstream msg;
        msg << "register_type for " << type_name.c_str()
            << " failed." << std::ends;
        throw std::runtime_error(msg.str());
      }
      
      return create_datawriter(participant,publisher,topic_name,type_name);
    }
    
} // MiddlewareNewsBrief

#endif 

