// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

using System;

namespace MiddlewareNewsBrief
{
   [Serializable]
   public class MarketDataEntry
   {
      public uint mdUpdateAction = 0;
      public uint mdPriceLevel = 0;
      public String mdEntryType = "";
      public uint openCloseSettleFlag = 0;
      public uint securityIDSource = 0;
      public uint securityID = 0;
      public uint rptSeq = 0;
      public double mdEntryPx = 0.0;
      public uint mdEntryTime = 0;
      public uint mdEntrySize = 0;
      public uint numberOfOrders = 0;
      public String tradingSessionID = "";
      public double netChgPrevDay = 0.0;
      public uint tradeVolume = 0;
      public String tradeCondition = "";
      public String tickDirection = "";
      public String quoteCondition = "";
      public uint aggressorSide = 0;
      public String matchEventIndicator = "";

      public static MarketDataEntry createTestData()
      {
         MarketDataEntry entry = new MarketDataEntry();

         entry.mdUpdateAction = 1;
         entry.mdPriceLevel = 2;
         entry.mdEntryType = "7";
         entry.openCloseSettleFlag = 3;
         entry.securityID = 99;
         entry.securityIDSource = 9;
         entry.rptSeq = 2;
         entry.mdEntryPx = 100.0;
         entry.mdEntryTime = 12345;
         entry.mdEntrySize = 50;
         entry.numberOfOrders = 10;
         entry.tradingSessionID = "2";
         entry.netChgPrevDay = 10.0;
         entry.tradeVolume = 30;
         entry.tradeCondition = "W";
         entry.tickDirection = "0";
         entry.quoteCondition = "C";
         entry.aggressorSide = 2;
         entry.matchEventIndicator = "1";

         return entry;
      }

   }
}
