// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

#include "RawTypeDetails.h"
#include "RawTypeSupportImpl.h"

#include "Profiler.h"
#include "DdsUtilPch.h"
#include "DDSUtil.h"
#include "DataReader_T.h"
#include "DoneTokenManager.h"

// OpenDDS
#include <dds/DCPS/Service_Participant.h>
#include <dds/DCPS/Marked_Default_Qos.h>
#include <dds/DCPS/SubscriberImpl.h>
#include <dds/DCPS/transport/framework/TheTransportFactory.h>

#include <iostream>
#include <set>

int main(int argc, char** argv)
{
  const int DOMAIN_ID = 8675309;

  try
  {
    //
    // OpenDDS Init
    //

    // Initialize, and create a DomainParticipantFactory
    DDS::DomainParticipantFactory_var factory = 
      TheParticipantFactoryWithArgs(argc, argv);

    //  Create the DomainParticipant
    DDS::DomainParticipant_var participant = 
      factory->create_participant(DOMAIN_ID,
                                  PARTICIPANT_QOS_DEFAULT,
                                  0,
                                  0);
    if (participant == 0) 
    {
      std::cerr << "create_participant failed." << std::endl;
      return -1;
    }

    // Create a subscriber for the topics
    const int TRANSPORT_IMPL_ID = 1;
    DDS::Subscriber_var subscriber = 
      MiddlewareNewsBrief::DDSUtil::create_subscriber(participant.in(),
                                                      TRANSPORT_IMPL_ID,
                                                      "Primary");
    
    // Create a publisher for the echo of the topics
    const int TRANSPORT_IMPL_ID_2= 2;
    DDS::Publisher_var publisher = 
      MiddlewareNewsBrief::DDSUtil::create_publisher(participant.in(),
                                                     TRANSPORT_IMPL_ID_2,
                                                     "Secondary");


    // Initialize the DoneToken manager, which publishes a "done" token
    MiddlewareNewsBrief::DoneTokenManager doneToken;
    doneToken.initReader(participant,publisher,subscriber);

    //
    // DataReaders, one per message type
    //

    MiddlewareNewsBrief::DataReader<MiddlewareNewsBrief::RawBuffer> rawDR;
    rawDR.init(participant,publisher,subscriber);

    printf("Finished subscribing; entering event loop\n");

    //
    // Process events
    //
    do 
    {
      boost::this_thread::sleep(boost::posix_time::seconds(1));
    } 
    while(!doneToken.isDone());

    doneToken.do_echo();

    // OpenDDS Cleanup
    doneToken.fini(publisher.in());
    if (participant != 0) 
    {
      participant->delete_contained_entities();
    }
    if (factory != 0) 
    {
      factory->delete_participant(participant.in ());
    }
    TheTransportFactory->release();
    TheServiceParticipant->shutdown();  
  }
  catch (std::exception & e)
  {
    std::cerr << e.what() << std::endl;
    return -1;
  }
  catch (CORBA::Exception& e) 
  {
    std::cerr << e << std::endl;
    return -1;
  }
  return 0;
}

