// Copyright (c) 2009, Object Computing, Inc.
// All rights reserved.
// See the file license.txt for licensing information.
//

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

#include "BoostPubUtil.h"

#include <iostream>
#include <stdexcept>
#include <cstdlib>
#include <cstring>
#include <boost/asio.hpp>
using boost::asio::ip::tcp;

// .NET
#include <vcclr.h>
using namespace System;
using namespace System::Runtime::InteropServices;

MiddlewareNewsBrief::BoostPubProxy::BoostPubProxy() 
: impl_(NULL)
{
  array<String^>^ arguments = Environment::GetCommandLineArgs();
  int argc = arguments->Length;
  char** argv = new char *[argc];
  for (int i=0; i<argc; i++) 
  {
    pin_ptr<const wchar_t> arg = PtrToStringChars(arguments[i]);

    // Convert wchar_t* to char*
    size_t origsize = wcslen(arg) + 1;
    size_t convertedChars = 0;
    char charArg[255];
    wcstombs_s(&convertedChars, charArg, origsize, arg, _TRUNCATE);

    argv[i] = _strdup(charArg);
  }

  impl_ = new BoostPubUtil(argc,argv,this);
}


MiddlewareNewsBrief::BoostPubProxy::~BoostPubProxy()
{
  delete impl_;
}


boost::uint32_t
MiddlewareNewsBrief::BoostPubProxy::get_num_subscribers()
{
  return impl_->get_num_subscribers();
}

boost::uint32_t 
MiddlewareNewsBrief::BoostPubProxy::get_num_messages()
{
  return impl_->get_num_messages();
}


void
MiddlewareNewsBrief::BoostPubProxy::write(array<unsigned char> ^managed_buffer)
{
  pin_ptr<unsigned char> pinned_managed_buffer = &managed_buffer[0];  
  impl_->write(&pinned_managed_buffer[0], managed_buffer->Length);
}


MiddlewareNewsBrief::BoostPubUtil::BoostPubUtil(
  int argc, 
  char** argv,
  gcroot<BoostPubProxy^> managed_parent)
  : managed_parent_(managed_parent)
  , num_messages_(std::atoi(argv[1]))
{
  // argv[0] is executable name, and argv[1] is number of messages
  // remaining arguments are <host> <port> pairs
  const size_t arg_offset = 2;

  num_subscribers_ = (argc - arg_offset) / 2;    
  subscribers_.reserve(num_subscribers_);
    
  for (size_t i=0; i < num_subscribers_; ++i)
  {
    tcp::resolver resolver(io_service_);
    tcp::resolver::query query(tcp::v4(), 
                               argv[i*2 + arg_offset], 
                               argv[i*2 + (arg_offset+1)]);
    tcp::resolver::iterator iterator = resolver.resolve(query);
    
    boost::shared_ptr<tcp::socket> s(new tcp::socket(io_service_));      
    subscribers_.push_back(s);
    s->connect(*iterator);
  }
}


void
MiddlewareNewsBrief::BoostPubUtil::write(unsigned char* buffer, size_t message_size)
{
  // Separate the write loop from the reply loop to simulate what a 
  // pub/sub service would do

  for (size_t jj = 0; jj < num_subscribers_; ++jj) {
    boost::asio::write(*(subscribers_[jj]), 
                       boost::asio::buffer(buffer, message_size));
  }

  boost::scoped_ptr<char> reply_buffer(new char[message_size]);
  for (size_t jj = 0; jj < num_subscribers_; ++jj) {
    // clear the buffer; we'll reuse it
    memset(reply_buffer.get(), 0, message_size);

    size_t reply_length = 
      boost::asio::read(*(subscribers_[jj]),
                        boost::asio::buffer(reply_buffer.get(), message_size));
    if (reply_length != message_size)
    {
      printf("Message reply size mismatch; expected %d, received %d\n", 
             message_size,
             reply_length);
    }

    // Have to copy to pass the sample's octet buffer up to the .NET layer
    array<unsigned char> ^managed_buffer = 
      gcnew array<unsigned char>(message_size);
    Marshal::Copy((IntPtr)reply_buffer.get(), managed_buffer, 0, message_size);
  
    this->managed_parent_->ProcessNotification( this->managed_parent_,
                                                managed_buffer);
  }
}


