// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma once
#endif
#ifndef MIDDLEWARENEWSBRIEF_DDSUTIL_DONETOKENMANAGER_H
#define MIDDLEWARENEWSBRIEF_DDSUTIL_DONETOKENMANAGER_H

#include "MiddlewareNewsBrief_DdsUtil_Export.h"
#include <string>

// OpenDDS
#include <RawTypeSupportImpl.h>
#include <dds/DCPS/Service_Participant.h>
#include <dds/DCPS/PublisherImpl.h>
#include <dds/DdsDcpsSubscriptionS.h>

// Profiler
#include "Profiler.h"

namespace MiddlewareNewsBrief {

    class MiddlewareNewsBrief_DdsUtil_Export DoneTokenManager : 
      public virtual OpenDDS::DCPS::LocalObject<DDS::DataReaderListener>
    {
    public:
      DoneTokenManager();
      ~DoneTokenManager();

      //
      // Writer
      //
  
      void initWriter(DDS::DomainParticipant_ptr participant,
                      DDS::Publisher_ptr publisher,
                      DDS::Subscriber_ptr subscriber);

      void writeDone(const std::string& msg);
      bool isDone() const;

      void do_echo();
      void fini(DDS::Publisher_ptr publisher);

      //
      // Reader, echos the "Done" token back to the Writer
      //

      void initReader(DDS::DomainParticipant_ptr participant,
                      DDS::Publisher_ptr publisher,                      
                      DDS::Subscriber_ptr subscriber);

      // DataReaderListener
      virtual void on_data_available(
        DDS::DataReader_ptr reader);

      virtual void on_subscription_matched (
        DDS::DataReader_ptr reader,
        const DDS::SubscriptionMatchedStatus & status)
      {}

      virtual void on_requested_deadline_missed (
        DDS::DataReader_ptr reader,
        const DDS::RequestedDeadlineMissedStatus & status)
      {}

      virtual void on_requested_incompatible_qos (
        DDS::DataReader_ptr reader,
        const DDS::RequestedIncompatibleQosStatus & status)
      {}

      virtual void on_liveliness_changed (
        DDS::DataReader_ptr reader,
        const DDS::LivelinessChangedStatus & status)
      {}

      virtual void on_sample_rejected(
        DDS::DataReader_ptr reader,
        const DDS::SampleRejectedStatus& status)
      {}

      virtual void on_sample_lost(
        DDS::DataReader_ptr reader,
        const DDS::SampleLostStatus& status)
      {}

    private:
      bool isDone_;
      mutable ACE_Thread_Mutex lock_;
      
      // OpenDDS
      MiddlewareNewsBrief::DoneTokenDataWriter_var writer_;
      bool is_original_publisher_side_;
    };

} // MiddlewareNewsBrief

#endif /* MIDDLEWARENEWSBRIEF_DDSUTIL_DONETOKENMANAGER_H */



