eval '(exit $?0)' && eval 'exec perl -S $0 ${1+"$@"}'
    & eval 'exec perl -S $0 $argv:q'
    if 0;

# $Id: zeromq_test.pl 2927 2010-01-21 19:08:30Z buschd $
# -*- perl -*-

#
# Launches a DCPSInfoRepo, 1 Zeromq-based Publisher process, and
# and N Zeromq-based Subscriber processes
#
# Usage: zeromq_test.pl  \
#              <ZeroMQ Test Prefix > [<message-size>] <num-messages> \
#              -bind <bind-to-pub, e.g. eth0, default to IP> \
#              -connect <connect-to-sub, e.g. spider, default to bind-to-pub>\
#              -num-subs <num subscribers>
#
#                 Don't provide <message-size> for "Typed" tests
#
#                 On Linux, it seems that
#
#                    -bind eth0 -connect <hostname>
#
#                 works best.  On Windows, either let the script find the
#                 IP address or use
#
#                    -bind <IP address>
#
#  e.g. zeromq_test.pl Zeromq 1000 10000 -num-subs 5
#       zeromq_test.pl Zeromq 1000 10000 -bind eth0 -connect spider -num-subs 5
#       zeromq_test.pl Zeromq 1000 10000 -bind 10.201.200.72 -num-subs 5
#       zeromq_test.pl ZeromqDotnet 1000 10000 -num-subs 5
#       zeromq_test.pl ZeromqTyped 10000 -num-subs 5
#       zeromq_test.pl ZeromqTypedDotnet 10000 -num-subs 5
#       zeromq_test.pl ZeromqTypedProtobuf 10000 -num-subs 5
#

use Env (DDS_ROOT);
use lib "$DDS_ROOT/bin";
use Env (ACE_ROOT);
use lib "$ACE_ROOT/bin";
use Env (MNB_ROOT);
use PerlDDS::Run_Test;

# Get the local host and IP address
use Socket;
use Sys::Hostname;
my $host = hostname();
my $ipaddr = inet_ntoa(scalar gethostbyname($host || 'localhost'));

print STDOUT "IP address = $ipaddr\n";
$bind_to_pub = $ipaddr;
$connect_to_sub = $ipaddr;

$status = 0;
$num_subs = 1;
@REMAINING_ARGV = ();
while (@ARGV) {
    $arg = $ARGV[0];

    if ($arg eq '-num-subs') {
        $num_subs = $ARGV[1];
        print STDOUT "$num_subs subscribers\n";
        shift @ARGV;
        shift @ARGV;
    } elsif ($arg eq '-bind') {
        $bind_to_pub = $ARGV[1];
        print STDOUT "bind address: $bind_to_pub\n";
        shift @ARGV;
        shift @ARGV;
    } elsif ($arg eq '-connect') {
        $connect_to_sub = $ARGV[1];
        print STDOUT "connect address: $connect_to_sub\n";
        shift @ARGV;
        shift @ARGV;
    } else {
        $REMAINING_ARGV[$#REMAINING_ARGV+1] = $arg;
        shift @ARGV;
    }    
}

$zmq_test_prefix = $REMAINING_ARGV[0];
$publisher_exe = "$MNB_ROOT/bin/$zmq_test_prefix" . "Publisher";
$subscriber_exe = "$MNB_ROOT/bin/$zmq_test_prefix" . "Subscriber";
$pub_port = 54321;
$sub_port = 54322;

$message_size = "";
if (not $zmq_test_prefix =~ /Typed/) {
    $message_size = $REMAINING_ARGV[1];
    shift @REMAINING_ARGV;
}
$num_messages = $REMAINING_ARGV[1];

$pub_opts = "$message_size $num_messages tcp://$bind_to_pub:$pub_port";
$sub_opts = "$message_size $num_messages";

@Subscribers = ();
for ($i = 0; $i < $num_subs; $i++) {    
    $pub_opts = "$pub_opts tcp://$connect_to_sub:$sub_port";
    $Subscribers[$i] = PerlDDS::create_process ("$subscriber_exe", " $sub_opts tcp://$bind_to_pub:$sub_port tcp://$connect_to_sub:$pub_port");
    $sub_port += 1;
}
$Publisher = PerlDDS::create_process ("$publisher_exe", " $pub_opts");

print $Subscribers[0]->CommandLine() . "\n";
foreach $sub (@Subscribers) {
  $sub->Spawn ();
}


print $Publisher->CommandLine() . "\n";
sleep ($num_subs + 1);
$Publisher->Spawn ();



$PublisherResult = $Publisher->WaitKill (300);
if ($PublisherResult != 0) {
    print STDERR "ERROR: publisher returned $PublisherResult \n";
    $status = 1;
}

foreach $sub (@Subscribers) {
  $SubscriberResult = $sub->WaitKill (100);
  if ($SubscriberResult != 0) {
      print STDERR "ERROR: subscriber returned $SubscriberResult \n";
      $status = 1;
  }
}

if ($status == 0) {
  print "test PASSED.\n";
} else {
  print STDERR "test FAILED.\n";
}

exit $status;
