// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifndef BOOST_UTIL_BOOSTPUBUTIL_H
#define BOOST_UTIL_BOOSTPUBUTIL_H

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

class Session;
#include <vector>
#include <cstdlib>
#include <cstring>
#include <boost/asio.hpp>
using boost::asio::ip::tcp;

// .NET
using namespace System;
#include <vcclr.h>

namespace MiddlewareNewsBrief
{
class BoostPubUtil;

// wrap OpenDDS interaction with a .NET class
public ref class BoostPubProxy
{
  // can't put an unmanaged thing in a ref class, but a 
  // pointer to an unmanaged thing is okay
  BoostPubUtil* impl_;

public:
  BoostPubProxy();
	~BoostPubProxy();

  boost::uint32_t get_num_subscribers();
  boost::uint32_t get_num_messages();
  void write(array<unsigned char> ^managed_buffer);

  delegate void EventHandler(Object^ sender, 
                             array<unsigned char> ^managed_buffer);
  EventHandler^ handler_;
  event EventHandler^ ProcessNotification
  {
    void add(EventHandler^ p) { handler_ +=p; }
    void remove(EventHandler^ p) { handler_ -=p; }
    void raise(Object^ obj, array<unsigned char> ^managed_buffer) {
      if (handler_!=nullptr) { 
        handler_(obj, managed_buffer);
      }
    }
  };
};
  
class BoostPubUtil
{
public:
  BoostPubUtil(int argc,
               char** argv,
               gcroot<BoostPubProxy^> managed_parent);

  size_t get_num_messages() const { return this->num_messages_; }
  size_t get_num_subscribers() const { return this->num_subscribers_; }
  void write(unsigned char* buffer, size_t message_size);
  
private:
  gcroot<BoostPubProxy^> managed_parent_;
  const size_t num_messages_;
  size_t num_subscribers_;

  boost::asio::io_service io_service_;
  std::vector<boost::shared_ptr<tcp::socket> > subscribers_;
};

} // namespace

#endif
