﻿// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using MiddlewareNewsBrief;

class TypedDotnetSubscriber
{
   OpenDdsPubSubProxy proxy_;

   int marketDataWriterHandle_ = -1;
   int quoteRequestDataWriterHandle_ = -1;
   IFormatter formatter_ = new BinaryFormatter();

   int message_count_ = 0;

   static int Main(string[] args)
   {
      TypedDotnetSubscriber me = new TypedDotnetSubscriber();
      me.Run(args);
      return 0;
   }

   public TypedDotnetSubscriber()
   {
   }

   int Run(string[] args)
   {
      const String QUOTE_TOPIC = "QuoteRequest";
      const String MARKET_DATA_TOPIC = "MarketData";

      // Initialize OpenDDS; publisher transport Id is 2 for subscriber process
      this.proxy_ = new OpenDdsPubSubProxy(MiddlewareNewsBrief.ProcessType.SUBSCRIBER_PROCESS);
      this.proxy_.ProcessNotification += new OpenDdsPubSubProxy.EventHandler(OnWriteReceived);

      this.marketDataWriterHandle_ = this.proxy_.createDataWriter(MARKET_DATA_TOPIC);
      this.quoteRequestDataWriterHandle_ = this.proxy_.createDataWriter(QUOTE_TOPIC);

      Console.Out.WriteLine("Ready to receive...");

      // Receive messages, and echo them back
      while (!this.proxy_.isDone())
      {
         System.Threading.Thread.Sleep(1000);
      }

      Console.Out.WriteLine("Done...");

      this.proxy_.fini();
      return 0;
   }

   // invoked when a DDS sample arrives
   void OnWriteReceived(object parent, int data_writer_handle, byte[] buffer)
   {
      // deserialize the buffer into a Quote or MarketData object

      MemoryStream stream = new MemoryStream(buffer);

      object obj = this.formatter_.Deserialize(stream);
      stream.Close();
      if (data_writer_handle == this.quoteRequestDataWriterHandle_)
      {
         // Verify the correct data type, and set the "echo" flag
         QuoteRequest qr = (QuoteRequest)obj;
         Debug.Assert(qr.isEcho == false, "Subscriber received echo sample");
         Debug.Assert(qr.counter == this.message_count_, "Message count mismatch");
         qr.isEcho = true;
      }
      else if (data_writer_handle == this.marketDataWriterHandle_)
      {
         // Verify the correct data type, and set the "echo" flag
         MarketData md = (MarketData)obj;
         Debug.Assert(md.isEcho == false, "Subscriber received echo sample");
         Debug.Assert(md.counter == this.message_count_, "Message count mismatch");
         md.isEcho = true;
      }
      else
      {
         Console.WriteLine("OnWriteReceived: no data_writer_handle for " + data_writer_handle);
         return;
      }

      ++this.message_count_;

      // Re-serialize the message and echo it back
      
      MemoryStream outStream = new MemoryStream();
      this.formatter_.Serialize(outStream, obj);
      outStream.Close();

      this.proxy_.write(data_writer_handle, outStream.ToArray());
   }
}
