﻿// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using MiddlewareNewsBrief;

class BoostTypedDotnetSubscriber
{
   BoostSubProxy proxy_;
   IFormatter formatter_ = new BinaryFormatter();
   ASCIIEncoding encoding_ = new System.Text.ASCIIEncoding();

   int message_count_ = 0;

   const String QUOTE_TOPIC = "QuoteRequest";
   const String MARKET_DATA_TOPIC = "MarketData";

   static unsafe int Main(string[] args)
   {
      BoostTypedDotnetSubscriber me = new BoostTypedDotnetSubscriber();
      me.Run(args);
      return 0;
   }

   public BoostTypedDotnetSubscriber()
   {
   }

   int Run(string[] args)
   {
      // Initialize OpenDDS; publisher transport Id is 2 for subscriber process
      this.proxy_ = new BoostSubProxy();
      this.proxy_.ProcessNotification += new BoostSubProxy.EventHandler(OnWriteReceived);

      Console.Out.WriteLine("Ready to receive...");

      // Receive messages, and echo them back
      this.proxy_.run();

      Console.Out.WriteLine("Done...");
      return 0;
   }

   // invoked when a DDS sample arrives
   void OnWriteReceived(object sender, byte[] msg, ulong sessionPtr)
   {
      // deserialize the buffer into a Quote or MarketData object

      // Get the "Topic" from the front of the byte array
      int topicEndIndex = Array.IndexOf(msg, (byte)'\x00');
      String topic = new String(this.encoding_.GetChars(msg, 0, topicEndIndex));

      MemoryStream inStream = new MemoryStream(msg);
      inStream.Seek(topic.Length + 1, SeekOrigin.Begin);

      object obj = this.formatter_.Deserialize(inStream);
      inStream.Close();

      if (topic.Equals(MARKET_DATA_TOPIC))
      {
         MarketData md = (MarketData)obj;
         Debug.Assert(md.isEcho == false, "Subscriber received echo sample");
         Debug.Assert(md.counter == this.message_count_, "Message count mismatch");
         md.isEcho = true;
      }
      else if (topic.Equals(QUOTE_TOPIC))
      {
         QuoteRequest qr = (QuoteRequest)obj;
         Debug.Assert(qr.isEcho == false, "Subscriber received echo sample");
         Debug.Assert(qr.counter == this.message_count_, "Message count mismatch");
         qr.isEcho = true;
      }
      else
      {
         Console.Out.WriteLine("ERROR: received topic " + topic);
         return;
      }

      ++this.message_count_;

      // Re-serialize the message and echo it back

      MemoryStream outStream = new MemoryStream();

      // "topic" for ZeroMQ
      outStream.Write(new System.Text.ASCIIEncoding().GetBytes(topic + '\x00'),
                      0,
                      topic.Length + 1);

      this.formatter_.Serialize(outStream, obj);
      outStream.Close();
      msg = outStream.ToArray();

      this.proxy_.echo(msg, sessionPtr);
   }
}
