// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

#include "BoostSubUtil.h"

#include <iostream>
#include <stdexcept>
#include <cstdlib>
#include <cstring>
#include <boost/asio.hpp>
#include <Server.h>

// .NET
#include <vcclr.h>
using namespace System;
using namespace System::Runtime::InteropServices;

MiddlewareNewsBrief::BoostSubProxy::BoostSubProxy() 
: impl_(NULL)
{
  array<String^>^ arguments = Environment::GetCommandLineArgs();
  int argc = arguments->Length;
  char** argv = new char *[argc];
  for (int i=0; i<argc; i++) 
  {
    pin_ptr<const wchar_t> arg = PtrToStringChars(arguments[i]);

    // Convert wchar_t* to char*
    size_t origsize = wcslen(arg) + 1;
    size_t convertedChars = 0;
    char charArg[255];
    wcstombs_s(&convertedChars, charArg, origsize, arg, _TRUNCATE);

    argv[i] = _strdup(charArg);
  }

  impl_ = new BoostSubUtil(argc,argv,this);
}


MiddlewareNewsBrief::BoostSubProxy::~BoostSubProxy()
{
  delete impl_;
}


void
MiddlewareNewsBrief::BoostSubProxy::run()
{
  impl_->run();
}


void
MiddlewareNewsBrief::BoostSubProxy::echo(array<unsigned char> ^managed_buffer,
                                         boost::uint64_t sessionPtr)
{
  pin_ptr<unsigned char> pinned_managed_buffer = &managed_buffer[0];  

  impl_->echo(&pinned_managed_buffer[0],
              managed_buffer->Length,
              reinterpret_cast<Session*>(sessionPtr));
}


MiddlewareNewsBrief::BoostSubUtil::BoostSubUtil(
  int argc, 
  char** argv,
  gcroot<BoostSubProxy^> managed_parent)
  : managed_parent_(managed_parent)
  , subscriber_port_(std::atoi(argv[2]))
  , num_messages_(std::atoi(argv[1]))
{
}


void 
MiddlewareNewsBrief::BoostSubUtil::run()
{
   boost::asio::io_service io_service;

   Server s(io_service, 
            subscriber_port_, 
            num_messages_, 
            boost::bind(&BoostSubUtil::on_data_available,this,_1,_2,_3));

   printf("Waiting; running for %d messages\n", num_messages_);

   io_service.run();
}

void
MiddlewareNewsBrief::BoostSubUtil::echo(unsigned char* buffer, 
                                        size_t num_bytes, 
                                        Session* session)
{
  session->write(reinterpret_cast<char*>(buffer), num_bytes);
}


void 
MiddlewareNewsBrief::BoostSubUtil::on_data_available(char* buffer, 
                                                     size_t num_bytes, 
                                                     Session* session)
{
  // Have to copy to pass the sample's octet buffer up to the .NET layer
  array<unsigned char> ^managed_buffer = gcnew array<unsigned char>(num_bytes);
  Marshal::Copy((IntPtr)buffer, managed_buffer, 0, num_bytes);
  
  this->managed_parent_->ProcessNotification( this->managed_parent_,
                                              managed_buffer,
                                              reinterpret_cast<boost::uint64_t>(session) );
}


