#ifndef BOOST_UTIL_BOOSTSUBUTIL_H
#define BOOST_UTIL_BOOSTSUBUTIL_H

// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.
// See the file license.txt for licensing information.
//

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

class Session;
#include <vector>
#include <boost/cstdint.hpp>

// .NET
using namespace System;
#include <vcclr.h>

namespace MiddlewareNewsBrief
{
class BoostSubUtil;

// wrap OpenDDS interaction with a .NET class
public ref class BoostSubProxy
{
  // can't put an unmanaged thing in a ref class, but a 
  // pointer to an unmanaged thing is okay
  BoostSubUtil* impl_;

public:
  BoostSubProxy();
	~BoostSubProxy();

  void run();
  void echo(array<unsigned char> ^managed_buffer, boost::uint64_t sessionPtr);

  delegate void EventHandler(Object^ sender, 
                             array<unsigned char> ^managed_buffer,
                             boost::uint64_t sessionPtr);
  EventHandler^ handler_;
  event EventHandler^ ProcessNotification
  {
    void add(EventHandler^ p) { handler_ +=p; }
    void remove(EventHandler^ p) { handler_ -=p; }
    void raise(Object^ obj,
               array<unsigned char> ^managed_buffer,
               boost::uint64_t sessionPtr) {
      if (handler_!=nullptr) { 
        handler_(obj, managed_buffer, sessionPtr);
      }
    }
  };
};
  
class BoostSubUtil
{
public:
  BoostSubUtil(int argc,
               char** argv,
               gcroot<BoostSubProxy^> managed_parent);

  void run();
  void echo(unsigned char* buffer, size_t num_bytes, Session* session);
  
  //
  // Callback for data available
  //

  void on_data_available(char* buffer, size_t num_bytes, Session* session);

private:
  gcroot<BoostSubProxy^> managed_parent_;
  size_t subscriber_port_;
  size_t num_messages_;
};

} // namespace

#endif
