#ifndef MIDDLEWARENEWSBRIEF_OPENDDSPUBSUBPROXY_H
#define MIDDLEWARENEWSBRIEF_OPENDDSPUBSUBPROXY_H

// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

// .NET
using namespace System;
#include <vcclr.h>

namespace MiddlewareNewsBrief
{
class OpenDdsPubSubUtil;

public enum class ProcessType {
  PUBLISHER_PROCESS,
  SUBSCRIBER_PROCESS
};

// wrap OpenDDS interaction with a .NET class
public ref class OpenDdsPubSubProxy
{
  // can't put an unmanaged thing in a ref class, but a 
  // pointer to an unmanaged thing is okay
  
  OpenDdsPubSubUtil* impl_;

public:
  OpenDdsPubSubProxy(ProcessType ptype);
	~OpenDdsPubSubProxy();

  // Returns an integer handle for writing to a particular topic
  int createDataWriter(String^ topic_name);

  void write(int data_writer_handle, array<unsigned char> ^managed_buffer);

  void writeDone();
  bool isDone();
  void fini();

  delegate void EventHandler(Object^ sender, 
                             int data_writer_handle, 
                             array<unsigned char> ^managed_buffer);
  EventHandler^ handler_;
  event EventHandler^ ProcessNotification
  {
    void add(EventHandler^ p) { handler_ +=p; }
    void remove(EventHandler^ p) { handler_ -=p; }
    void raise(Object^ obj, int data_writer_handle, array<unsigned char> ^managed_buffer) {
      if (handler_!=nullptr) { 
        handler_(obj, data_writer_handle, managed_buffer);
      }
    }
  };
};

} // namespace

#endif
