// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma warning(disable:4996) // Disable VC warning from Boost serialization
# pragma warning(disable:4099) // Disable VC warning from Boost serialization
#endif

#include "zmq.hpp"
#include <iostream>
#include "MarketData.h"
#include "QuoteRequest.h"
#include "Functions_T.h"
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <boost/archive/binary_oarchive.hpp>
#include <boost/archive/binary_iarchive.hpp>
#include <boost/detail/atomic_count.hpp>

int main (int argc, char *argv [])
{
  try {
    if (argc != 4) {
      std::cout << "usage: ZeromqTypedSubscriber <roundtrip-count> <bind-to-sub> <connect-to-pub>\n"
                << "e.g.:  ZeromqTypedSubscriber 10000 tcp://eth0:54322 tcp://spider:54321\n"
                << "          use a literal IP address and port for each endpoint\n"
                << std::endl;
        return 1;
    }
    size_t roundtrip_count = atoi (argv [1]);
    const char* bind_to_sub = argv [2];
    const char* connect_to_pub = argv [3];

    zmq::context_t ctx (1, 1);
    zmq::socket_t pub (ctx, ZMQ_PUB);
    pub.connect(connect_to_pub);

    zmq::socket_t sub (ctx, ZMQ_SUB);
    sub.setsockopt(ZMQ_SUBSCRIBE,"MarketData\x00",11);
    sub.setsockopt(ZMQ_SUBSCRIBE,"QuoteRequest\x00",13);
    sub.bind(bind_to_sub);

    boost::detail::atomic_count msg_counter(0);

    printf("Entering recv loop -- %d messages\n", 
           roundtrip_count);

    for (size_t i = 0; i < roundtrip_count; i++) {
      zmq::message_t msg;
      sub.recv (&msg);

      char* msg_buffer = reinterpret_cast<char*>(msg.data());
      
      // "topic" name should be first N characters, null-terminated
      std::string topic_name(msg_buffer);

      std::istringstream request(
        std::string(msg_buffer + topic_name.length() + 1,
                    msg.size() - (topic_name.length() + 1)),
        std::ios::binary);
      boost::archive::binary_iarchive ia(request);

      std::ostringstream reply(std::ios::binary);
      boost::archive::binary_oarchive oa(reply);

      if (topic_name == MiddlewareNewsBrief::MarketData::TOPIC) 
      {
        MiddlewareNewsBrief::MarketData md;
        MiddlewareNewsBrief::check_and_restream(md,ia,oa,msg_counter);
      } 
      else if (topic_name == MiddlewareNewsBrief::QuoteRequest::TOPIC)
      {
        MiddlewareNewsBrief::QuoteRequest qr;
        MiddlewareNewsBrief::check_and_restream(qr,ia,oa,msg_counter);
      }
      else 
      {
        std::cerr << "Received invalid topic name: " << topic_name.c_str() << std::endl;
        return -1;
      }

      // Echo it back
      size_t reply_length = reply.str().length() + topic_name.length() + 1;
      zmq::message_t reply_msg(reply_length);
      memset(reply_msg.data(),0,reply_msg.size());
      memcpy(reply_msg.data(),topic_name.c_str(),topic_name.length());
      memcpy(reinterpret_cast<char*>(reply_msg.data()) + topic_name.length() + 1,reply.str().data(),reply.str().length());

      pub.send(reply_msg,0);

      ++msg_counter;
    }
    printf("Finished receiving messages\n");
    
    return 0;

  } catch (std::exception &e) {
    std::cout << "An error occurred: " << e.what() << std::endl;
    return 1;
  }
}
