eval '(exit $?0)' && eval 'exec perl -S $0 ${1+"$@"}'
    & eval 'exec perl -S $0 $argv:q'
    if 0;

# $Id: raw_test.pl 2927 2010-01-21 19:08:30Z buschd $
# -*- perl -*-

#
# Launches a DCPSInfoRepo, 1 RawPublisher process and N RawSubscriber processes
#
# Usage: raw_test.pl <Raw Test Prefix> [-tr tcp|mcast] [-num-subs N] \
#                    [-num <number-of-messages>]
#
#  e.g.  opendds_test.pl Raw -num-subs 5
#        opendds_test.pl Typed -num 10000 -num-subs 5
#        opendds_test.pl TypedDotnet -tr mcast -num-subs 5
#

use Env (DDS_ROOT);
use lib "$DDS_ROOT/bin";
use Env (ACE_ROOT);
use lib "$ACE_ROOT/bin";
use Env (MNB_ROOT);
use PerlDDS::Run_Test;

$status = 0;
$use_svc_config = !new PerlACE::ConfigList->check_config ('STATIC');

# Service Configurator
$opts = $use_svc_config ? "-ORBSvcConf $MNB_ROOT/config/lib_tcp.conf" : '';

# InfoRepo IOR
$dcpsrepo_ior_file = "repo.ior";
$dcps_repo_ior = "file://$dcpsrepo_ior_file";
$opts = "$opt -DCPSInfoRepo $dcps_repo_ior -ORBSvcConf $MNB_ROOT/config/lib_tcp.conf";
$trans_opts = "-DCPSConfigFile $MNB_ROOT/config/tcp_conf.ini";

$num_subs = 1;
@REMAINING_ARGV = ();
while (@ARGV) {
    $arg = $ARGV[0];

    if ($arg eq '-tr') {
        $transport = $ARGV[1];
        if ($transport eq 'tcp') {
            # nothing to do
        } elsif ($transport eq 'mcast') {
            $trans_opts = "-ORBSvcConf $MNB_ROOT/config/lib_mcast.conf -DCPSConfigFile $MNB_ROOT/config/mcast_conf.ini";
        } else {
            print STDERR "ERROR: invalid transport $transport\n";
            exit 1;
        }
        shift @ARGV;
        shift @ARGV;
    } elsif ($arg eq '-num-subs') {
        $num_subs = $ARGV[1];
        print STDOUT "$num_subs subscribers\n";
        shift @ARGV;
        shift @ARGV;
    } else {
        $REMAINING_ARGV[$#REMAINING_ARGV+1] = $arg;
        shift @ARGV;
    }    
}

$raw_test_prefix = $REMAINING_ARGV[0];
shift @REMAINING_ARGV;
$subscriber_exe = "$MNB_ROOT/bin/$raw_test_prefix" . "Subscriber";
$publisher_exe = "$MNB_ROOT/bin/$raw_test_prefix" . "Publisher";

$opts = "$opts $trans_opts";
$argv_opts = join " ", @REMAINING_ARGV;

unlink $dcpsrepo_ior_file;

$DCPSREPO = PerlDDS::create_process ("$ENV{DDS_ROOT}/bin/DCPSInfoRepo",
                                     "-ORBSvcConf $MNB_ROOT/config/lib_tcp.conf -o $dcpsrepo_ior_file ");

@Subscribers = ();
for ($i = 0; $i < $num_subs; $i++) {
    $Subscribers[$i] = PerlDDS::create_process ("$subscriber_exe", "$opts");
}
$Publisher = PerlDDS::create_process ("$publisher_exe", " $opts $argv_opts -ns $num_subs");

print $DCPSREPO->CommandLine() . "\n";
$DCPSREPO->Spawn ();
if (PerlACE::waitforfile_timed ($dcpsrepo_ior_file, 30) == -1) {
    print STDERR "ERROR: waiting for DCPSInfo IOR file\n";
    $DCPSREPO->Kill ();
    exit 1;
}

print $Subscribers[0]->CommandLine() . "\n";
foreach $sub (@Subscribers) {
  $sub->Spawn ();
}

print $Publisher->CommandLine() . "\n";
sleep ($num_subs + 3);
$Publisher->Spawn ();


$PublisherResult = $Publisher->WaitKill (300);
if ($PublisherResult != 0) {
    print STDERR "ERROR: publisher returned $PublisherResult \n";
    $status = 1;
}

foreach $sub (@Subscribers) {
  $SubscriberResult = $sub->WaitKill (100);
  if ($SubscriberResult != 0) {
      print STDERR "ERROR: subscriber returned $SubscriberResult \n";
      $status = 1;
  }
}

$ir = $DCPSREPO->TerminateWaitKill(5);
if ($ir != 0) {
    print STDERR "ERROR: DCPSInfoRepo returned $ir\n";
    $status = 1;
}

unlink $dcpsrepo_ior;

if ($status == 0) {
  print "test PASSED.\n";
} else {
  print STDERR "test FAILED.\n";
}

exit $status;
