// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

#include "OpenDdsPubSubProxy.h"
#include "OpenDdsPubSubUtil.h"

#include "RawTypeSupportImpl.h"


MiddlewareNewsBrief::OpenDdsPubSubProxy::OpenDdsPubSubProxy(ProcessType ptype) 
: impl_(NULL)
{
  array<String^>^ arguments = Environment::GetCommandLineArgs();
  int argc = arguments->Length;
  char** argv = new char *[argc];
  for (int i=0; i<argc; i++) 
  {
    pin_ptr<const wchar_t> arg = PtrToStringChars(arguments[i]);

    // Convert wchar_t* to char*
    size_t origsize = wcslen(arg) + 1;
    size_t convertedChars = 0;
    char charArg[255];
    wcstombs_s(&convertedChars, charArg, origsize, arg, _TRUNCATE);

    argv[i] = _strdup(charArg);
  }

  impl_ = new OpenDdsPubSubUtil(argc,argv,this,ptype);
}


MiddlewareNewsBrief::OpenDdsPubSubProxy::~OpenDdsPubSubProxy()
{
  delete impl_;
}


int
MiddlewareNewsBrief::OpenDdsPubSubProxy::createDataWriter(String^ topic_name)
{
  int retval = -1;
  
  int len = (( topic_name->Length+1) * 2); 
  char* target = new char[ len ]; 
  pin_ptr<const wchar_t> wch = PtrToStringChars( topic_name ); 
  if (wcstombs( target, wch, len ) != -1) {
    retval = impl_->create_datawriter(target);
  }
  delete target;
  return retval;
}


void
MiddlewareNewsBrief::OpenDdsPubSubProxy::write(
  int data_writer_handle, 
  array<unsigned char> ^managed_buffer)
{
  pin_ptr<unsigned char> pinned_managed_buffer = &managed_buffer[0];  

  MiddlewareNewsBrief::BufferType destination;
  destination.replace(managed_buffer->Length,
                      managed_buffer->Length,
                      &pinned_managed_buffer[0],
                      false);

  impl_->write(data_writer_handle, destination);
}


void
MiddlewareNewsBrief::OpenDdsPubSubProxy::writeDone()
{
  impl_->write_done();
}


bool
MiddlewareNewsBrief::OpenDdsPubSubProxy::isDone()
{
  return impl_->is_done();
}


void
MiddlewareNewsBrief::OpenDdsPubSubProxy::fini()
{
  impl_->fini();
}


