#ifndef MIDDLEWARENEWSBRIEF_OPENDDSPUBSUBUTIL_H
#define MIDDLEWARENEWSBRIEF_OPENDDSPUBSUBUTIL_H

// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

#include "RawTypeSupportImpl.h"

// DdsUtil
#include <DataWriter_T.h>
#include <DoneTokenManager.h>

// OpenDDS
#include <dds/DCPS/Service_Participant.h>
#include <dds/DCPS/Marked_Default_Qos.h>
#include <dds/DCPS/PublisherImpl.h>

#include <vector>

// .NET
using namespace System;
#include "OpenDdsPubSubProxy.h"
#include <vcclr.h>

namespace MiddlewareNewsBrief
{
class OpenDdsPubSubUtil
  : public virtual OpenDDS::DCPS::LocalObject<DDS::DataReaderListener>
{
public:
  OpenDdsPubSubUtil(int argc,
                    char** argv,
                    gcroot<OpenDdsPubSubProxy^> managed_parent,
                    ProcessType ptype);
  ~OpenDdsPubSubUtil();

  // Returns an integer handle for the writer
  int create_datawriter(char* topic_name);

  void write(int data_writer_handle, MiddlewareNewsBrief::BufferType& buffer);

  void write_done();
  bool is_done() const;
  void fini();

  //
  // DataReaderListener
  //

  virtual void on_data_available(
    DDS::DataReader_ptr reader
  )
  throw (CORBA::SystemException);

  virtual void on_requested_deadline_missed (
    DDS::DataReader_ptr reader,
    const DDS::RequestedDeadlineMissedStatus & status)
    throw (CORBA::SystemException)
  {}

  virtual void on_requested_incompatible_qos (
    DDS::DataReader_ptr reader,
    const DDS::RequestedIncompatibleQosStatus & status)
  throw (CORBA::SystemException)
  {}

  virtual void on_liveliness_changed (
    DDS::DataReader_ptr reader,
    const DDS::LivelinessChangedStatus & status)
  throw (CORBA::SystemException)
  {}

  virtual void on_subscription_matched (
    DDS::DataReader_ptr reader,
    const DDS::SubscriptionMatchedStatus & status
  )
  throw (CORBA::SystemException)
  {}

  virtual void on_sample_rejected(
    DDS::DataReader_ptr reader,
    const DDS::SampleRejectedStatus& status
  )
  throw (CORBA::SystemException)
  {}

  virtual void on_sample_lost(
    DDS::DataReader_ptr reader,
    const DDS::SampleLostStatus& status
  )
  throw (CORBA::SystemException)
  {}

private:
  void ctor_publisher();
  void ctor_subscriber();

  DDS::DomainParticipantFactory_var factory_;
  DDS::DomainParticipant_var participant_;
  DDS::Publisher_var publisher_;
  DDS::Subscriber_var subscriber_;
  MiddlewareNewsBrief::DoneTokenManager doneToken_;

  struct Writer {
    MiddlewareNewsBrief::RawBufferDataWriter_var writer_;
    DDS::InstanceHandle_t instance_handle_;
  };
  typedef std::vector<Writer> Writers;
  Writers writers_;

  typedef std::map<std::string,int> TopicToWriterHandle;
  TopicToWriterHandle topicToWriterHandle_;

  MiddlewareNewsBrief::RawBuffer payload_;
  gcroot<OpenDdsPubSubProxy^> managed_parent_;

  const std::string PRIMARY_PARTITION;
  const std::string SECONDARY_PARTITION;
};


} // namespace

#endif
