// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

using System;

namespace MiddlewareNewsBrief
{
   [Serializable]
   public class MarketData
   {
      public uint securityID = 0;
      public String applVersionID = "";
      public String messageType = "";
      public String senderCompID = "";
      public uint msgSeqNum = 0;
      public uint sendingTime = 0;
      public uint tradeDate = 0;

      public bool isEcho = false;
      public uint counter = 0;

      public MarketDataEntry[] mdEntries = new MarketDataEntry[0];

      public static MarketData createTestData()
      {
         MarketData data = new MarketData();

         data.applVersionID = "1.0";
         data.messageType = "100";
         data.senderCompID = "Test Exchange";
         data.msgSeqNum = 4;
         data.sendingTime = 00162635;
         data.tradeDate = 20100422;

         data.mdEntries = new MarketDataEntry[3];
         data.mdEntries[0] = MarketDataEntry.createTestData();
         data.mdEntries[1] = MarketDataEntry.createTestData();
         data.mdEntries[2] = MarketDataEntry.createTestData();

         return data;
      }

   }
}
