// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

using System;

namespace MiddlewareNewsBrief
{
   [Serializable]
   public class QuoteRequest
   {
      public uint securityID = 0;
      public String applVersionID = "";
      public String messageType = "";
      public String senderCompID = "";
      public uint msgSeqNum = 0;
      public uint sendingTime = 0;
      public String quoteReqID = "";

      public bool isEcho = false;
      public uint counter = 0;

      public RelatedSym[] related = new RelatedSym[0];

      public static QuoteRequest createTestData()
      {
         QuoteRequest req = new QuoteRequest();

         req.applVersionID = "1.0";
         req.messageType = "100";
         req.senderCompID = "Test Exchange";
         req.msgSeqNum = 4;
         req.sendingTime = 00162635;
         req.quoteReqID = "R";

         req.related = new RelatedSym[3];
         req.related[0] = RelatedSym.createTestData();
         req.related[1] = RelatedSym.createTestData();
         req.related[2] = RelatedSym.createTestData();

         return req;
      }
   }
}
