#include "matrix.h"
#include "mm_basic_omp.h"
#include <iostream>
#include <stdlib.h>
#include <omp.h>

int main(int argc,char *argv[]) {
  int n = 50;
  if (argc>1)
    n = atoi(argv[1]);
  
  Matrix I(n,n);
  Identity(I);
  Matrix A(n,n);
  Fill(A);
  
  Matrix product(n,n);
  Clear(product);
  double start = omp_get_wtime();
  mm_basic_omp(I,A,product);
  double end = omp_get_wtime();
  std::cout << n << " " << end-start << std::endl;

  if (!Compare(A,product)) {
    std::cout << "not equal" << std::endl;
    return 1;
  }

  return 0;
}
