#include "matrix.h"
#include "mm_cache.h"

#include <string.h>
#include <iostream>
#include <iomanip>
#include <stdlib.h>
#include <omp.h>

int main(int argc,char *argv[]) {
  int n = 50;
  if (argc>1)
    n = atoi(argv[1]);
  int threshold = 5;
  if (argc>2)
    threshold = atoi(argv[2]);
 
  Matrix I(n,n);
  Identity(I);
  Matrix A(n,n);
  Fill(A);
  
  Matrix product(n,n);
  Clear(product);
  double start = omp_get_wtime();
  mm_cache(I,A,product, threshold);
  double end = omp_get_wtime();
  std::cout << n << " " << end-start << " " << threshold << std::endl;

  if (!Compare(A,product)) {
    std::cout << "not equal" << std::endl;
    return 1;
  }
  
  
  return 0;
}
