#include "matrix.h"
#include <assert.h>
#include <iostream>
#include <iomanip>

void Clear(Matrix &m) {
  for (int i=0; i<m.Rows(); i++)
    for (int j=0; j<m.Cols(); j++)
      m(i,j) = 0;
}

void Identity(Matrix &m) {
  // must be square
  assert(m.Rows() == m.Cols());
  Clear(m);
  for (int i=0; i<m.Rows(); i++)
    m(i,i) = 1;  // diagonal is 1, otherwise 0
}

// fill (row order, 1...N-1, N...2N-1, ...)
void Fill(Matrix &m) {
  int v=0;
  for (int i=0; i<m.Rows(); i++)
    for (int j=0; j<m.Cols(); j++)
      m(i,j) = v++;
}


bool Compare(const Matrix &a, const Matrix &b) {
  if ((a.Rows()!=b.Rows()) || (a.Cols()!=b.Cols()))
    return false;
  for (int i=0; i<a.Rows(); i++)
    for (int j=0; j<a.Cols(); j++)
      if (a(i,j) != b(i,j)) 
	return false;
  return true;
}


void Print(const Matrix &m) {
  for (int i=0; i<m.Rows(); i++) {
    for (int j=0; j<m.Cols(); j++)
      std::cout << std::setw(5) << m(i,j) << " ";
    std::cout << std::endl;
  }
}

/*
void Randomize(Matrix &m) {
	srand((unsigned int)time(0));
	for (int i=0; i<m.Rows(); i++)
		for (int j=0; j<m.Cols(); j++)
			m(i,j) = rand();
}
*/



