#ifndef __MATRIX_H__
#define __MATRIX_H__

class Matrix {
  int rows_;
  int cols_;
  int *data_;
  
 public:
  Matrix() : rows_(0), cols_(0), data_(0) {}
  Matrix(int rows, int cols) : rows_(rows), cols_(cols) {
    data_ = new int[rows_*cols_];
  }
  ~Matrix() { delete [] data_; }
  int Rows() const { return rows_; }
  int Cols() const { return cols_; }
  
  int operator()(int row, int col) const { return data_[row*cols_+col]; }  
  int &operator()(int row, int col) { return data_[row*cols_+col]; }
};

void Clear(Matrix &);
void Fill(Matrix &);
void Identity(Matrix &);
bool Compare(const Matrix &, const Matrix &);
void Print(const Matrix &);

#endif
