#include "matrix.h"
#include <ace/Thread_Manager.h>

struct mm_thread_param {
  const Matrix &a_;
  const Matrix &b_;
  Matrix &product_;
  int iLow_;
  int iHigh_;
  
  mm_thread_param(const Matrix &a, const Matrix &b, Matrix &product, int iLow, int iHigh) :
    a_(a), b_(b), product_(product), iLow_(iLow), iHigh_(iHigh) {}
};

ACE_THR_FUNC_RETURN mm_thread(void *param) {
  mm_thread_param *p = reinterpret_cast<mm_thread_param *>(param);

  for (int i=p->iLow_; i<p->iHigh_; i++)
    for (int j=0; j<p->b_.Cols(); j++)
      for (int k=0; k<p->a_.Cols(); k++)
	p->product_(i,j) += p->a_(i,k) * p->b_(k,j);
  
  delete p;
  return 0;
}

void mm_basic_ace(const Matrix &a, const Matrix &b, Matrix &product, int nthread) {
  ACE_Thread_Manager tm;
  tm.open();
  
  for (int t=0; t<nthread; t++) 
    tm.spawn(mm_thread, new mm_thread_param(a, b, product, t*a.Rows()/nthread, (t+1)*a.Rows()/nthread));
  
  tm.wait();
  tm.close();
}
