#include "matrix.h"
#include "mm_basic_ace.h"
#include <iostream>
#include <stdlib.h>
#include <omp.h>
#include <ace/OS_NS_unistd.h>

int main(int argc,char *argv[]) {
  int n = 50;
  if (argc>1)
    n = atoi(argv[1]);

  Matrix I(n,n);
  Identity(I);
  Matrix A(n,n);
  Fill(A);
  
  Matrix C(n,n);
  Clear(C);
  double start = omp_get_wtime();
  mm_basic_ace(I,A,C, ACE_OS::num_processors());
  double end = omp_get_wtime();
  std::cout << n << " " << end-start << std::endl;

  if (!Compare(A,C)) {
    std::cout << "not equal" << std::endl;
    return 1;
  }

  return 0;
}
