#include "matrix.h"
#include "mm_cache_omp2.h"
#include "mm_cache.h"
#include <omp.h>

void mm_cache_omp2(const Matrix &a, const Matrix &b, Matrix &product, int threshold) {
  #pragma omp parallel
  {
    int start = omp_get_thread_num()*a.Rows()/omp_get_num_threads();
    int end = (omp_get_thread_num()+1)*a.Rows()/omp_get_num_threads();
    mm_cache(a,b,product, start,end, 0,b.Cols(), 0,a.Cols(), threshold);
  }
}
