#!/bin/sh

# groff: -e to process with eqn, -p to process with pic
# gs: must have -q so stdout doesn't get non-image garbage
# pnmcrop: remove whitespace from image, else get 8.5x11 page
# convert: scale for antialiasing

groff -e -p -ms $1.ms | gs -q -sDEVICE=ppmraw -sOutputFile='-' -r600x600 -dBATCH -dNOPAUSE - | pnmcrop | convert - -resize 50% $1.jpg


# latex file.tex - creates file.dvi
# dvipng file.dvi
# convert file.png -trim file2.png



