#include <iostream>
#include <omp.h>

int main() {
  std::cout << "Number of threads (outside parallel block): " << 
    omp_get_num_threads() << std::endl;

  #pragma omp parallel
  {
    #pragma omp master
    std::cout << "Number of threads (inside parallel block): " << 
      omp_get_num_threads() << std::endl;

#pragma omp barrier

    for (int i=0; i<16; i++) 
    {
      #pragma omp critical(log)
      std::cout << "<" << omp_get_thread_num() << ":" << i << ">" << std::flush;
    }
  }

  std::cout << std::endl;
  return 0;
}

  
