#include <iostream>
#include <omp.h>
#include "ms_sleep.h"


int main() {
  double start = omp_get_wtime();
#pragma omp parallel for schedule(dynamic) num_threads(2)
  for (int i=0; i<4; i++) 
  {
    #pragma omp critical(log)
    std::cout << "<" << omp_get_thread_num() << ":" << i << ">" << std::flush;
    if (i<2)
      ms_sleep(5000);  // simulate long work
    else
      ms_sleep(500);  // simulate short work
  }

  double end = omp_get_wtime();

  std::cout << std::endl << "Elapsed: " << end-start << std::endl;
  return 0;
}

  
