#!/usr/bin/perl

use strict;
use List::Util qw(sum);

sub read_file {
    my $filename = shift;

    my %data = ();

    my ($n,$t);
    open(DATAFILE, "$filename") || die("Cannot open $filename\n");
    while(<DATAFILE>) {
	chomp $_;
	($n,$t) = split(" ", $_);
	# print $n . " -> " . $t . "\n";
	$data{$n} = $t;
	# print $data{$n} . "\n";
    }

    return %data;
}

# read all data, toss max and min, average remaining, write back out

my %data = ();

for my $filename (@ARGV) {
    print "Processing $filename...\n";
    my %data_file = read_file($filename);
    for my $key (keys %data_file) {
	my $value = $data_file{$key};
	#print "$key => $value\n";

	# make each hash element an array containing values for that key 
	# (execution times for a given N)
	push(@{$data{$key}}, $value);
    }
}


my %avg_data = ();
foreach my $key (keys %data) {
# sort data in numerically increasing order
    @{$data{$key}} = sort { $a <=> $b } @{$data{$key}};

# drop the min and max
    @{$data{$key}} = @{$data{$key}}[1..$#{$data{$key}}-1];

# store the average of the remaining elements
    $avg_data{$key} = sum(@{$data{$key}})/@{$data{$key}};
}


my @keys = keys %data;
@keys = sort { $a <=> $b } @keys;  # numeric sort of keys
foreach my $key (@keys) {
    print "$key: ";
    foreach (@{$data{$key}}) {
	print "$_ ";
    }
    print "= $avg_data{$key}\n";
}

print "Writing avg_data.dat...\n";
open FILE, ">avg_data.dat" or die $!; 
my @keys = keys %data;
@keys = sort { $a <=> $b } @keys;  # numeric sort of keys
foreach my $key (@keys) {
    print FILE "$key $avg_data{$key}\n";
}

close FILE;
