#include <iostream>
#include <fstream>
#include <string>
#include <ace/arg_shifter.h>
#include "MathS.h"

class MathImpl : public virtual POA_MathModule::Math {
public:
  MathImpl() {}
  virtual ~MathImpl() {}
  virtual ::CORBA::Long Add(::CORBA::Long x, ::CORBA::Long y) {
      return x+y;
  }
};


void GetArgs(int argc, char *argv[], std::string &ior_file) {
    ACE_Arg_Shifter arg_shifter(argc, argv);
    while (arg_shifter.is_anything_left()) {
		const ACE_TCHAR *currentArg = 0;
        if ((currentArg = arg_shifter.get_the_parameter(ACE_TEXT("-ior"))) != 0) {
			ior_file = currentArg;
            arg_shifter.consume_arg();
        }
		else
            arg_shifter.ignore_arg();
    }	
}


int main(int argc, char *argv[]) {
    try {
		// obtain arguments
		std::string ior_file;
		GetArgs(argc, argv, ior_file);

        // initialize the ORB
        CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

        // obtain a reference to the RootPOA
        CORBA::Object_var obj = 
            orb->resolve_initial_references("RootPOA");
        PortableServer::POA_var poa = 
            PortableServer::POA::_narrow(obj.in());

        // activate the POAManager
        PortableServer::POAManager_var mgr = poa->the_POAManager();
        mgr->activate();
        
        // create the Math servant
        MathImpl servant;
        PortableServer::ObjectId_var oid = 
            poa->activate_object(&servant);
		CORBA::Object_var math_obj = poa->id_to_reference(oid.in());
        
        // write the object reference to a file
        CORBA::String_var ior = orb->object_to_string(math_obj.in());
        std::ofstream out(ior_file.c_str());
		out << ior;
        out.close();

        // accept requests from clients
        orb->run();
        
        // cleanup
        orb->destroy();
    }
    catch (CORBA::Exception& ex) {
        std::cerr << "CORBA exception: " << ex << std::endl;
		return 1;
    }

    return 0;
}     