using System;
using System.Runtime.Remoting.Channels;
using System.Threading;
using Ch.Elca.Iiop;
using omg.org.CORBA;
using System.IO;


public class MathImpl : MarshalByRefObject, MathModule.Math
{
    public int Add(int x, int y)
    {
        return x+y;
    }
}


public class MathServer {
	public static void Main(string[] args) {
        // obtain arguments
        string iorFile = args[Array.IndexOf(args, "-ior") + 1];
		int port = 8087;
        int portIndex = Array.IndexOf(args, "-port");
        if (portIndex>=0)
            port = int.Parse(args[portIndex+1]);

        // initialize the channel
		IiopChannel chan = new IiopChannel(port);
		ChannelServices.RegisterChannel(chan, false);

        // create the Math servant
        MathImpl math = new MathImpl();

        // write the object reference to a file
        OrbServices orb = OrbServices.GetSingleton();
        String ior = orb.object_to_string(math);
        StreamWriter sw = new StreamWriter(iorFile);
        sw.WriteLine(ior);
        sw.Close();
        
		// accept requests from clients
		Thread.Sleep(Timeout.Infinite);
	}
}
