import java.io.*;

public class Server {
    public static void main(String[] args) {
        try {
            // obtain arguments
            String ior_file = "";
            for (int i=0; i<args.length; i++)
                if (args[i].equals("-ior")) 
                    ior_file = args[i+1];
            
            // initialize the ORB
            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, null);

			// obtain a reference to the RootPOA
            org.omg.PortableServer.POA poa = 
                org.omg.PortableServer.POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
                
            // activate the POAManager
            poa.the_POAManager().activate();
            
            // create the Math servant
            org.omg.CORBA.Object o = poa.servant_to_reference(new MathImpl());

			// write the object reference to a file
            PrintWriter ps = new PrintWriter(new FileOutputStream(new File(ior_file)));
            ps.println(orb.object_to_string(o));
            ps.close();     
            
            // accept requests from clients
            orb.run();
            
            // cleanup
            orb.destroy();
        }
        catch (Exception e)
        {
            e.printStackTrace();   
        }
    }
}