eval '(exit $?0)' && eval 'exec perl -w -S $0 ${1+"$@"}'
    & eval 'exec perl -w -S $0 $argv:q'
    if 0;

use Env '$OPALORB_ROOT';
use lib "$OPALORB_ROOT";
use strict;

use CORBA;
use CORBA::Exception;
use MathImpl;
use Getopt::Long;

my $status = 0;

try {
  # obtain arguments
  my $ior_file;
  GetOptions('ior=s' => \$ior_file);
    
  # initialize the ORB
  my $orb = CORBA::ORB_init(\@ARGV);

  # obtain a reference to the root POA
  my $poa = $orb->resolve_initial_references('RootPOA');
  
  # activate the POAManager
  my $poamanager = $poa->the_POAManager();
  $poamanager->activate();

  # create the Math servant
  my $impl = new MathImpl($orb);
  my $id = $poa->activate_object($impl);
  my $obj = $poa->id_to_reference($id);
  my $servant = MathModule::Math::_narrow($obj);

  # write the object reference to a file
  my $fh = new FileHandle();
  if (open($fh, ">$ior_file")) {
    print $fh $orb->object_to_string($servant);
    close($fh);
  }

  # accept requests from clients
  $orb->run();

  # cleanup
  $orb->destroy();
}
catch CORBA::Exception with {
  my $ex = shift;
  print STDERR "EXCEPTION: $ex\n";
  $status++;
};

exit($status);
