using System;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting;
using Ch.Elca.Iiop;
using System.IO;

public class MathClient {

    public static void Main(string[] args) {
        try {
            // obtain arguments
            string iorFile = args[Array.IndexOf(args, "-ior") + 1];
            int addIndex = Array.IndexOf(args, "-add");
            int x = int.Parse(args[addIndex + 1]);
            int y = int.Parse(args[addIndex + 2]);

            // initialize the channel
            IiopClientChannel channel = new IiopClientChannel();
            ChannelServices.RegisterChannel(channel, false);  

            // obtain an object reference
            StreamReader stream = new StreamReader(iorFile);
            String ior = stream.ReadLine();
            MathModule.Math math = (MathModule.Math)RemotingServices.Connect(typeof(MathModule.Math), ior);

            // invoke the method
            Console.WriteLine("Sum: " + math.Add(x, y));
        } catch (Exception e) {
            Console.WriteLine("Exception: " + e);
        }
    }
}
