-module(dds).
-export([publisher_test/1, subscriber_test/1, init_stop/0]).

init_stop() -> init:stop().

publisher_test([Gateway, Message]) ->
	publisher_test_loop(list_to_atom(Gateway), Message, 10).

wait(MS) ->
	receive
		after MS -> true
	end.
		
publisher_test_loop(Gateway, Message, Count) ->
	if 
	  Count >= 0 -> 
	    io:format("[Erlang ~p] Publish: msg='~p' id=~p~n", [node(), Message, Count]),
	  	{ any, Gateway } ! { publish, { Message, Count } },
	  	wait(1000),
	  	publisher_test_loop(Gateway, Message, Count-1);
	  true ->
	    { any, Gateway } ! { shutdown },
	  	io:format("[Erlang ~p]: done~n", [node()]),
	  	init_stop()
	end.
	  	
subscriber_test([Gateway]) ->
	{ any, list_to_atom(Gateway) } ! { subscribe, self() },
	subscriber_test_loop(list_to_atom(Gateway)).
	
subscriber_test_loop(Gateway) ->
	receive
	    { message, _, 0 } ->
	        { any, Gateway } ! { shutdown },
			io:format("[Erlang ~p]: done~n", [node()]),
			init_stop();
		{ message, Msg, Id } ->
			io:format("[Erlang ~p] Received: msg='~p' id=~p~n", [node(), Msg, Id]),
			subscriber_test_loop(Gateway);
		Any ->
			io:format("[Erlang ~p]: Received unknown message ~p~n", [node(), Any]),
			subscriber_test_loop(Gateway)
	end.
	
	