eval '(exit $?0)' && eval 'exec perl -S $0 ${1+"$@"}'
    & eval 'exec perl -S $0 $argv:q'
    if 0;

use Env (DDS_ROOT);
use lib "$DDS_ROOT/bin";
use Env (ACE_ROOT);
use lib "$ACE_ROOT/bin";
use PerlDDS::Run_Test;

# Erlang Publisher test

use Sys::Hostname;
# my $host = hostname;
my @arr = split(/\./, hostname);
my $host = $arr[0]; 
print $host . "\n";  # should be cko3, oci1373, etc.

use Env '$ERL_ROOT';
my $erl_path = "$ERL_ROOT/bin/erl";

$status = 0;
$dcpsrepo_ior = "repo.ior";
unlink $dcpsrepo_ior;

# Start an Erlang node just to ensure that epmd is running
$ErlangInit = PerlDDS::create_process("$erl_path", "-sname dummy -setcookie secretcookie -pa ../Erlang -noshell -run dds init_stop");
print $ErlangInit->CommandLine() . "\n";
$ErlangInit->Spawn();
$ErlangInitResult = $ErlangInit->WaitKill(300);

# Start the InfoRepo
$DCPSREPO = PerlDDS::create_process ("$ENV{DDS_ROOT}/bin/DCPSInfoRepo",
                                     "-ORBDebugLevel 10 -ORBLogFile DCPSInfoRepo.log -o $dcpsrepo_ior");
print $DCPSREPO->CommandLine() . "\n";
$DCPSREPO->Spawn ();
if (PerlACE::waitforfile_timed($dcpsrepo_ior, 30) == -1) {
    print STDERR "ERROR: waiting for DCPSInfo IOR file\n";
    $DCPSREPO->Kill ();
    exit 1;
}

# Start the gateway as node alice
$Gateway = PerlDDS::create_process ("../CPP/Gateway/gateway", "-ORBSvcConf tcp.conf -sname alice -setcookie secretcookie -port 8001");
print $Gateway->CommandLine() . "\n";
$Gateway->Spawn();

# Start the subscriber
$Subscriber = PerlDDS::create_process ("../CPP/Subscriber/subscriber", "-ORBSvcConf tcp.conf");
print $Subscriber->CommandLine() . "\n";
$Subscriber->Spawn();

# pause a bit to be sure the subscriber has time to subscribe to the topic before the publisher starts
sleep(5);

# Run the Erlang publisher as node bob - it will exit when it has published all of its samples
$erlhost = 'alice@' . $host;
$Publisher = PerlDDS::create_process("$erl_path", "-sname bob -setcookie secretcookie -pa ../Erlang -noshell -run dds publisher_test $erlhost Message");
print $Publisher->CommandLine() . "\n";
$Publisher->Spawn();
$PublisherResult = $Publisher->WaitKill(300);
if ($PublisherResult != 0) {
    print STDERR "ERROR: publisher returned $PublisherResult \n";
    $status = 1;
}

# Gateway will have shut down from the shutdown message sent by the publisher
$GatewayResult = $Gateway->WaitKill(300);
if ($GatewayResult != 0) {
    print STDERR "ERROR: gateway returned $GatewayResult \n";
    $status = 1;
}

# The subscriber should have shut down on its own
$SubscriberResult = $Subscriber->WaitKill(300);
if ($SubscriberResult != 0) {
    print STDERR "ERROR: subscriber returned $PublisherResult \n";
    $status = 1;
}

$ir = $DCPSREPO->TerminateWaitKill(5);
if ($ir != 0) {
    print STDERR "ERROR: DCPSInfoRepo returned $ir\n";
    $status = 1;
}

unlink $dcpsrepo_ior;

exit $status;
