#ifndef __EIEXCEPTION_H__
#define __EIEXCEPTION_H__

#include <exception>
#include <string>
#include <ace/OS.h>
#include "defs.h"


class EIException : public MyException {
	std::string I2A(int i) {
		char buf[33];
		return ACE_OS::itoa(i, buf, 10);
	}
public:
	EIException(const char *what, int err=0) : MyException((std::string(what) + std::string(": ") + ((err==0)?std::string():I2A(err))).c_str()) {}
};


class EIEncodeException : public EIException {
public:
	EIEncodeException(const char *what) : EIException(what) {}
};
class EIDecodeException : public EIException {
public:
	EIDecodeException(const char *what) : EIException(what) {}
};


#endif
