#ifndef __XBUFF_H__
#define __XBUFF_H__

#include <ei.h>
#include "EIException.h"

class XBuff;

class XBuffDecoder {
	ei_x_buff &_buff;
	int _offset;

	XBuffDecoder(ei_x_buff &buff) : _buff(buff), _offset(0) {}

	void GetType(int &type, int &size) {
		if (ei_get_type(_buff.buff, &_offset, &type, &size) < 0)
			throw EIDecodeException("ei_get_type failed");
	}

public:
	int GetVersion() {
		int version;
		if (ei_decode_version(_buff.buff, &_offset, &version) < 0)
			throw EIDecodeException("ei_decode_version failed");
		return version;
	}

	int GetTupleHeader() {
		int arity;
		if (ei_decode_tuple_header(_buff.buff, &_offset, &arity) < 0) 
			throw EIDecodeException("ei_decode_tuple_header failed");
		return arity;
	}

	std::string GetAtom() {
		char atom[MAXATOMLEN+1];
		if (ei_decode_atom(_buff.buff, &_offset, atom) < 0)
			throw EIDecodeException("ei_decode_atom failed");
		return atom;
	}

	std::string GetString() {
		int type, size;
		GetType(type, size);
		char *p = new char[size+1];
		if (p == NULL)
			throw EIDecodeException("ei_malloc failed");
		if (ei_decode_string(_buff.buff, &_offset, p) < 0) {
			delete [] p;
			throw EIDecodeException("ei_decode_string failed");
		}
		std::string s = p;
		delete [] p;
		return s;
	}

	erlang_pid GetPID() {
		erlang_pid pid;
		if (ei_decode_pid(_buff.buff, &_offset, &pid) < 0)
			throw EIDecodeException("ei_decode_atom failed");
		return pid;
	}

	long GetLong() {
		long l;
		if (ei_decode_long(_buff.buff, &_offset, &l) < 0)
			throw EIDecodeException("ei_decode_long failed");
		return l;
	}

	// more data types

	friend class XBuff;
};








class XBuffEncoder {
	ei_x_buff &_buff;

	XBuffEncoder(ei_x_buff &buff) : _buff(buff) {}
public:

	void SetTupleHeader(int arity) {
		if (ei_x_encode_tuple_header(&_buff, arity) < 0)
			throw EIEncodeException("ei_x_encode_tuple_header failed");
	}
	void SetAtom(std::string atom) {
		if (ei_x_encode_atom(&_buff, atom.c_str()) < 0)
			throw EIEncodeException("ei_x_encode_atom failed");
	}
	void SetLong(long l) {
		if (ei_x_encode_long(&_buff, l) < 0)
			throw EIEncodeException("ei_x_encode_long failed");
	}
	void SetString(std::string str) {
		if (ei_x_encode_string(&_buff, str.c_str()) < 0)
			throw EIEncodeException("ei_x_encode_atom failed");
	}

	// more types

    friend class XBuff;
};


class XBuff {
	ei_x_buff _buff;

public:
	XBuff(bool initWithVersion) {
		if (initWithVersion)
			ei_x_new_with_version(&_buff);
		else
			ei_x_new(&_buff);
	}
	~XBuff() {
		ei_x_free(&_buff);
	}

	ei_x_buff *get() { return &_buff; }

	XBuffDecoder GetDecoder() { return XBuffDecoder(_buff); }
	XBuffEncoder GetEncoder() { return XBuffEncoder(_buff); }
};



#endif