#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <ace/Arg_Shifter.h>
#include "MathC.h"

class MyException : public std::exception {
	std::string _what;
public:
	MyException(const char *what) : _what(what) {}
	~MyException() throw() {}
	const char *what() { return _what.c_str(); }
};

void GetArgs(int argc, char *argv[],
	std::string &ior, int &x, int &y) {
		ACE_Arg_Shifter arg_shifter(argc, argv);
		while (arg_shifter.is_anything_left()) {
			const ACE_TCHAR *currentArg = 0;
			if ((currentArg = arg_shifter.get_the_parameter(ACE_TEXT("-add"))) != 0) {
				x = ACE_OS::atoi(currentArg);
				arg_shifter.consume_arg();
				y = ACE_OS::atoi(arg_shifter.get_current());
				arg_shifter.consume_arg();
			}
			if ((currentArg = arg_shifter.get_the_parameter(ACE_TEXT("-ior"))) != 0) {
				std::ifstream in(currentArg);
				if (!in)
					throw MyException((std::string("Cannot open ") + currentArg).c_str());
				std::ostringstream ss;
				ss << in.rdbuf();
				if (!in && !in.eof())
					throw MyException((std::string("Cannot read IOR from ") + currentArg).c_str());
				ior = ss.str();
				arg_shifter.consume_arg();
			}
			else
				arg_shifter.ignore_arg();
		}	
}

int main(int argc, char *argv[]) {
	try {        
		// obtain arguments
		std::string ior;
		int x=2, y=2;
		GetArgs(argc, argv, ior, x, y);

		// initialize the ORB
		CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

		// obtain an object reference
		CORBA::Object_var obj = orb->string_to_object(ior.c_str());
		MathModule::Math_var math = MathModule::Math::_narrow(obj.in());
		if (CORBA::is_nil(math.in()))
			throw MyException("IOR was not a Math object reference");

		// invoke the method
		std::cout << "Sum: " << math->Add(x,y) << std::endl;

		// cleanup
		orb->destroy();
	}
	catch (CORBA::Exception& ex) {
		std::cerr << "CORBA exception: " << ex << std::endl;
		return 1;
	}
	catch (std::exception& e) {
		std::cerr << "Exception: " << e.what() << std::endl;
		return 1;
	}

	return 0;
}     
