#include <ace/OS_NS_stdlib.h>
#include "DataReaderListenerImpl.h"
#include "MessengerTypeSupportC.h"
#include "MessengerTypeSupportImpl.h"
#include <iostream>
#include <memory>
#include "defs.h"

void
	DataReaderListenerImpl::on_requested_deadline_missed(
	DDS::DataReader_ptr /*reader*/,
	const DDS::RequestedDeadlineMissedStatus& /*status*/)
	ACE_THROW_SPEC((CORBA::SystemException))
{
}

void
	DataReaderListenerImpl::on_requested_incompatible_qos(
	DDS::DataReader_ptr /*reader*/,
	const DDS::RequestedIncompatibleQosStatus& /*status*/)
	ACE_THROW_SPEC((CORBA::SystemException))
{
}

void
	DataReaderListenerImpl::on_sample_rejected(
	DDS::DataReader_ptr /*reader*/,
	const DDS::SampleRejectedStatus& /*status*/)
	ACE_THROW_SPEC((CORBA::SystemException))
{
}

void
	DataReaderListenerImpl::on_liveliness_changed(
	DDS::DataReader_ptr /*reader*/,
	const DDS::LivelinessChangedStatus& /*status*/)
	ACE_THROW_SPEC((CORBA::SystemException))
{
}

void
	DataReaderListenerImpl::on_data_available(DDS::DataReader_ptr reader)
	ACE_THROW_SPEC((CORBA::SystemException))
{
	Messenger::MessageDataReader_var reader_i =
		Messenger::MessageDataReader::_narrow(reader);

	if (CORBA::is_nil(reader_i.in())) {
		ACE_ERROR((LM_ERROR,
			ACE_TEXT("ERROR: %N:%l: on_data_available() -")
			ACE_TEXT(" _narrow failed!\n")));
		ACE_OS::exit(-1);
	}

	MessageType message(new Messenger::Message);
	DDS::SampleInfo info;

	DDS::ReturnCode_t error = reader_i->take_next_sample(*message, info);

	if (error == DDS::RETCODE_OK) {

		if (info.valid_data)
			_messageQueue.Insert(message);

	} else {
		ACE_ERROR((LM_ERROR,
			ACE_TEXT("ERROR: %N:%l: on_data_available() -")
			ACE_TEXT(" take_next_sample failed!\n")));
	}
}

void
	DataReaderListenerImpl::on_subscription_matched(
	DDS::DataReader_ptr /*reader*/,
	const DDS::SubscriptionMatchedStatus& /*status*/)
	ACE_THROW_SPEC((CORBA::SystemException))
{
}

void
	DataReaderListenerImpl::on_sample_lost(
	DDS::DataReader_ptr /*reader*/,
	const DDS::SampleLostStatus& /*status*/)
	ACE_THROW_SPEC((CORBA::SystemException))
{
}