#ifndef __RUNNABLE_H__
#define __RUNNABLE_H__

#include <ace/Thread.h>

class Runnable {
public:
	virtual void *Svc() = 0;
};

class Runner {
	ACE_hthread_t _thread;
	Runnable *_runnable; 

	static void *Run(void *p) {
		Runnable *runnable = (reinterpret_cast<Runner *>(p))->_runnable;
		void *rtn = runnable->Svc();
		delete runnable;
		return rtn;
	}

public:
 Runner(Runnable *runnable) : _thread(0), _runnable(runnable) {}

	void Start() {
		ACE_Thread::spawn(reinterpret_cast<ACE_THR_FUNC>(Run), this, THR_NEW_LWP|THR_JOINABLE, 0, &_thread);
	}

	void Wait() {
		if (_thread != 0)
			ACE_Thread::join(_thread);
	}
};


#endif
