#ifndef __DDSMPI_BYTAG_H__
#define __DDSMPI_BYTAG_H__

#include "DDSMPIBase.h"

class DDSMPILib_Export DDSMPI_ByTag : public DDSMPIBase {
    DDS::Topic_var _topic;
    DDS::Publisher_var _pub;
    MPIMessage::MessageByTagDataWriter_var _mdw;
    std::vector<DDS::Subscriber_var> _sub;
    std::vector<MPIMessage::MessageByTagDataReader_var> _mdr;
    std::map<int, DDS::InstanceHandle_t> _writerInstances;
    std::map<int, std::map<int, DDS::InstanceHandle_t> > _readerInstances;

    std::map<int, DDS::StatusCondition_var> _statusConditions;
    std::map<int, DDS::WaitSet_var> _waitSets;

    void Take(int tag, int whichReader, MPIMessage::MessageByTagSeq &messageSeq);
    void WaitOnDataAvailable(int whichReader);
public:
    void Initialize(int &argc, ACE_TCHAR *argv[]);
    void Shutdown();
    void Send(void *buf, int count, int dest, int tag);
    void Recv(void *buf, int count, int source, int tag, int &actualSource, int &actualTag);
    std::string GetType() const { return "DDSMPI_ByTag"; }
};

#endif
