#include "DDSMPIBase_ByRank.h"
#include "DDSException.h"
#include "GetArgs.h"
#include "dds/DCPS/Marked_Default_Qos.h"
#include "dds/DCPS/Service_Participant.h"



void DDSMPIBase_ByRank::BeginByRankInitialize(int &argc, ACE_TCHAR *argv[]) {
    BaseInitialize(argc, argv);

    MPIMessage::MessageByRankTypeSupport_var ts = new MPIMessage::MessageByRankTypeSupportImpl;
    if (ts->register_type(_dp, "") != DDS::RETCODE_OK)
        throw DDSException(_rank, "DDSMPIBase_ByRank::BeginByRankInitialize(): reigster_type() failed");

    CORBA::String_var type_name = ts->get_type_name();
    _topic = _dp->create_topic("MPITopic", type_name, TOPIC_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
    if (0 == _topic) 
        throw DDSException(_rank, "DDSMPIBase_ByRank::BeginByRankInitialize(): create_topic() failed");
}


void DDSMPIBase_ByRank::EndByRankInitialize(int subscriptionCount) {
    WaitForSubscriptionCount(_mdr, subscriptionCount);

    // CREATE A WAIT SET TO WAIT ON FOR ARRIVING SAMPLES
   _dataAvailableStatus = _mdr->get_statuscondition();
   _dataAvailableStatus->set_enabled_statuses(DDS::DATA_AVAILABLE_STATUS);
   _dataAvailable = new DDS::WaitSet;
   _dataAvailable->attach_condition(_dataAvailableStatus);
}


void DDSMPIBase_ByRank::BeginByRankShutdown() {
    // delete the datareader
    if (_sub->delete_datareader(_mdr) != DDS::RETCODE_OK)
        throw DDSException(_rank, "DDSMPIBase_ByRank::BeginByRankShutdown(): _sub->delete_datareader() failed");
    _mdr = 0;
}



// in MPI wrapper use MPI constants to determine how much actual data to send
void DDSMPIBase_ByRank::CommonByRankSend(MPIMessage::MessageByRankDataWriter_ptr mdw, void *buf, int count, int dest, int tag) {
    MPIMessage::MessageByRank sample;
    sample.senderRank = _rank;
    sample.recipientRank = dest;
    sample.tag = tag;
    sample.data.length(count);
    CORBA::Octet *ptr = (CORBA::Octet *)buf; 
    for (int i=0; i<count; i++)
        sample.data[i] = ptr[i];
    if (mdw->write(sample, _instances[(dest == DDSMPI_BROADCAST) ? _size : dest]) != DDS::RETCODE_OK)
        throw DDSException(_rank, "DDSMPIBase_ByRank::CommonByRankSend(): mdw->write() failed");
}



void DDSMPIBase_ByRank::Recv(void *buf, int count, int source, int tag, int &actualSource, int &actualTag) {
    // source could be DDSMPI_ANY_SOURCE for a match
    // tag could be DDSMPI_ANY_TAG for a match

    CORBA::Octet *ptr = (CORBA::Octet *)buf;

    // first, check if any pending messages match the criteria - if so, remove and use
    for (std::list<MPIMessage::MessageByRank>::iterator it = _messages.begin(); it != _messages.end(); it++) {
        if ( ((source == DDSMPI_ANY_SOURCE) || (source == it->senderRank)) && 
             ((tag == DDSMPI_ANY_TAG) || (tag == it->tag))) {
                 actualSource = it->senderRank;
                 actualTag = it->tag;
                 for (int i=0; i<count; i++)
                    ptr[i] = it->data[i];
                 _messages.erase(it);
                 return;
        }
    }

    DDS::Duration_t infinite = {DDS::DURATION_INFINITE_SEC, DDS::DURATION_INFINITE_NSEC};
    DDS::ConditionSeq conditions;
    MPIMessage::MessageByRankSeq messageSeq;
    DDS::SampleInfoSeq infoSeq;
    while (true) {
        // if no pending message matched, block waiting for a sample to come in
        conditions.length(0);
        if (DDS::RETCODE_OK != _dataAvailable->wait(conditions, infinite)) 
            throw DDSException(_rank, "DDSMPIBase_ByRank::Recv(): _dataAvailable->wait() failed");

        // receive the sample
        DDS::ReturnCode_t ret = _mdr->take(messageSeq, infoSeq, 1, DDS::ANY_SAMPLE_STATE, DDS::ANY_VIEW_STATE, DDS::ANY_INSTANCE_STATE);
        if (ret != DDS::RETCODE_OK) 
            throw DDSException(_rank, "DDSMPIBase_ByRank::Recv(): _mdr->take() should have returned data");

        if (!infoSeq[0].valid_data)
            continue;  // wasn't a valid data sample, so try again

        // if the source and tag match, accept the message and exit
        if ( ((source == DDSMPI_ANY_SOURCE) || (source == messageSeq[0].senderRank)) && 
             ((tag == DDSMPI_ANY_TAG) || (tag == messageSeq[0].tag))) {
                 actualSource = messageSeq[0].senderRank;
                 actualTag = messageSeq[0].tag;
                 for (int i=0; i<count; i++)
                    ptr[i] = messageSeq[0].data[i];
                 return;
        }

        // not a match, so queue it, and continue to wait
        _messages.push_back(messageSeq[0]);
    }
}



