#include "DDSMPI_CFT.h"
#include <sstream>
#include "DDSException.h"
#include "dds/DCPS/transport/framework/TransportRegistry.h"
#include "dds/DCPS/Marked_Default_Qos.h"

void DDSMPI_CFT::Initialize(int &argc, ACE_TCHAR *argv[]) {
    BeginByRankInitialize(argc, argv);

    // CREATE THE PUBLISHER AND DATAWRITER
    _pub = _dp->create_publisher(PUBLISHER_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
    if (0 == _pub) 
        throw DDSException(_rank, "DDSMPI_CFT::Initialize(): create_publisher() failed");
    OpenDDS::DCPS::TransportRegistry::instance()->bind_config("c", _pub);

    _mdw = MPIMessage::MessageByRankDataWriter::_narrow(CreateDataWriter(_pub, _topic));
    if (0 == _mdw) 
        throw DDSException(_rank, "DDSMPI_CFT::Initialize(): writer _narrow() failed");

    // CREATE AN INSTANCE HANDLE FOR EACH RECIPIENT
    MPIMessage::MessageByRank sample;
    for (int i=0; i<=_size; i++) {
        sample.recipientRank = (i==_size) ? DDSMPI_BROADCAST : i;  // _instances[_size] is broadcast
        _instances.push_back(_mdw->register_instance(sample));
    }


    // CREATE THE SUBSCRIBER
    _sub = _dp->create_subscriber(SUBSCRIBER_QOS_DEFAULT, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
    if (0 == _sub) 
		throw DDSException(_rank, "DDSMPI_CFT::Initialize(): create_subscriber() failed");
    OpenDDS::DCPS::TransportRegistry::instance()->bind_config("c", _sub);

    // CREATE THE CONTENT-FILTERED TOPIC, FILTERED BY SUBSCRIBER RANK    
    std::ostringstream filter;
    filter << "(recipientRank = " << _rank << ") OR (recipientRank = " << DDSMPI_BROADCAST << ")";
    DDS::ContentFilteredTopic_var cft = _dp->create_contentfilteredtopic("MPITopic-PerSubscriber", _topic, filter.str().c_str(), DDS::StringSeq());

    // CREATE THE DATAREADER
    _mdr = MPIMessage::MessageByRankDataReader::_narrow(CreateDataReader(_sub, cft));
    if (0 == _mdr) 
        throw DDSException(_rank, "DDSMPI_CFT::Initialize(): reader _narrow() failed");


    // WAIT FOR ASSOCIATIONS
    WaitForPublicationCount(_mdw, _size);
    EndByRankInitialize(_size); 
}



// in MPI wrapper use MPI constants to determine how much actual data to send
void DDSMPI_CFT::Send(void *buf, int count, int dest, int tag) {
    CommonByRankSend(_mdw, buf, count, dest, tag);
}







void DDSMPI_CFT::Shutdown() {
    //std::cout << "CFT: shutdown" << std::endl;

    // wait until all messages have been acknowledged
    DDS::Duration_t fivesec = {5, 0};
    _mdw->wait_for_acknowledgments(fivesec);

    //std::cout << "CFT: common shutdown" << std::endl;
    BeginByRankShutdown();

    //std::cout << "CFT: wait for publication count" << std::endl;
    // wait until the datawriter has no publications (all other subscribers have deleted their datareader)
    WaitForPublicationCount(_mdw, 0);

    // delete the remaining entities and shut down
    MPIMessage::MessageByRank sample;
    for (int i=0; i<=_size; i++) {
        sample.recipientRank = (i==_size) ? DDSMPI_BROADCAST : i;
        _mdw->unregister_instance(sample, _instances[i]);
    }
    _instances.clear();

    BaseShutdown();
}






