#include "DDSMPI_Partition.h"
#include <sstream>
#include "DDSException.h"
#include "dds/DCPS/Marked_Default_Qos.h"
#include "dds/DCPS/transport/framework/TransportRegistry.h"

void DDSMPI_Partition::Initialize(int &argc, ACE_TCHAR *argv[]) {
    BeginByRankInitialize(argc, argv);

    // CREATE THE PUBLISHERS AND DATAWRITERS
    DDS::StringSeq part;
    DDS::PublisherQos pub_qos;
    for (int i=0; i<=_size; i++) {
        _dp->get_default_publisher_qos(pub_qos);
        part.length(1);
        std::ostringstream name;
        name << ((i==_size) ? -1 : i);
        part[0] = name.str().c_str();
        pub_qos.partition.name = part;
        DDS::Publisher_var pub = _dp->create_publisher(pub_qos, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
        if (0 == pub) 
            throw DDSException(_rank, "create_publisher() failed");
        OpenDDS::DCPS::TransportRegistry::instance()->bind_config("c", pub);
        _pub.push_back(pub);  // array is _size+1 elements - _pub[size] is the broadcast publisher

        MPIMessage::MessageByRankDataWriter_var mdw = MPIMessage::MessageByRankDataWriter::_narrow(CreateDataWriter(pub, _topic));
        if (0 == mdw) 
            throw DDSException(_rank, "writer _narrow() failed");
        _mdw.push_back(mdw);  // array is _size+1 elements - _mdw[size] is the broadcast writer
    }


    // CREATE AN INSTANCE HANDLE FOR EACH RECIPIENT
    MPIMessage::MessageByRank sample;
    for (int i=0; i<=_size; i++) {
        sample.recipientRank = (i==_size) ? DDSMPI_BROADCAST : i;  // _instances[_size] is the broadcast instance
        _instances.push_back(_mdw[i]->register_instance(sample));
    }


    // CREATE THE SUBSCRIBER AND DATAREADER
    DDS::SubscriberQos sub_qos;
    _dp->get_default_subscriber_qos(sub_qos);
    part.length(2);
    std::ostringstream recipientRank;
    recipientRank << _rank;
    part[0] = recipientRank.str().c_str();  // receive samples for the particular rank of the subscriber
    std::ostringstream broadcast;
    broadcast << DDSMPI_BROADCAST;
    part[1] = broadcast.str().c_str();  // receive broadcast samples, too
    sub_qos.partition.name = part;
    _sub = _dp->create_subscriber(sub_qos, 0, OpenDDS::DCPS::DEFAULT_STATUS_MASK);
    if (0 == _sub) 
		throw DDSException(_rank, "create_subscriber() failed");
    OpenDDS::DCPS::TransportRegistry::instance()->bind_config("c", _sub);

    _mdr = MPIMessage::MessageByRankDataReader::_narrow(CreateDataReader(_sub, _topic));
    if (0 == _mdr) 
        throw DDSException(_rank, "reader _narrow() failed");

    // WAIT FOR ASSOCIATIONS 
    for (int i=0; i<=_size; i++)
        WaitForPublicationCount(_mdw[i], (i ==_size) ? _size : 1);  // broadcast matches everyone, but rank matches just 1 subscriber

   EndByRankInitialize(2*_size);  // every process has one publisher that matches the recipient rank, and one for broadcast, so 2
}



// in MPI wrapper use MPI constants to determine how much actual data to send
void DDSMPI_Partition::Send(void *buf, int count, int dest, int tag) {
    CommonByRankSend(_mdw[(dest == DDSMPI_BROADCAST) ? _size : dest], buf, count, dest, tag);
}


void DDSMPI_Partition::Shutdown() {
    //std::cout << "Partition: shutdown" << std::endl;

    // wait until all messages have been acknowledged
    DDS::Duration_t infinite = {DDS::DURATION_INFINITE_SEC, DDS::DURATION_INFINITE_NSEC};
    for (int i=0; i<=_size; i++) 
        _mdw[i]->wait_for_acknowledgments(infinite);

    //std::cout << "Partition: common shutdown" << std::endl;
    BeginByRankShutdown();
    
    //std::cout << "Partition: wait for publication count" << std::endl;
    // wait until the datawriter has no publications (all other subscribers have deleted their datareader)
    for (int i=0; i<=_size; i++) 
        WaitForPublicationCount(_mdw[i], 0);

    // delete the remaining entities and shut down
    MPIMessage::MessageByRank sample;
    for (unsigned int i=0; i<_instances.size(); i++) {
        sample.recipientRank = (i==_size) ? DDSMPI_BROADCAST : i;
        _mdw[i]->unregister_instance(sample, _instances[i]);
    }
    _instances.clear();

    BaseShutdown();
}




