#include "GetArgs.h"
#include <ace/Arg_Shifter.h>

// be sure to use &argc as the value will change as args are consumed
bool GetArg(int &argc, ACE_TCHAR *argv[], const ACE_TCHAR *arg, int &value) {

    bool foundArg = false;
    ACE_Arg_Shifter arg_shifter(argc, argv);
    while (arg_shifter.is_anything_left()) {
        const ACE_TCHAR *currentArg = 0;
        if ((currentArg = arg_shifter.get_the_parameter(arg)) != 0) {
            value = ACE_OS::atoi(currentArg);
            arg_shifter.consume_arg();
            foundArg = true;  // can't "return true" here as it will drop any arguments following the matched one
        }
        else
            arg_shifter.ignore_arg();
    }
    return foundArg;
}
