#ifndef __DDSEXCEPTION_H__
#define __DDSEXCEPTION_H__

#include <exception>
#include <sstream>

class DDSMPILib_Export DDSException : public std::exception {
	std::string _what;
public:
	DDSException(const char *what) : _what(what) {}
    DDSException(int rank, const char *what)  {
        std::ostringstream w;
        w << rank << "> " << what;
        _what = w.str();
    }
	~DDSException() throw() {}
	const char *what() const throw() { return _what.c_str(); }
};

#endif
