#ifndef __DDSMPIBASE_H__
#define __DDSMPIBASE_H__

#include "dds/DCPS/WaitSet.h"
#include "MPIMessageTypeSupportImpl.h"
#include "DDSMPILib_Export.h"
#include <list>
#include <string>

class DDSMPILib_Export DDSMPIBase {
protected:
    int _rank;
    int _size;
    DDS::DomainParticipant_var _dp;

    void BaseInitialize(int &argc, ACE_TCHAR *argv[]);
    void BaseShutdown();
    void WaitForSubscriptionCount(::DDS::DataReader_ptr mdr, int subscriptionCount);
    void WaitForPublicationCount(::DDS::DataWriter_ptr mdw, int publicationCount);
    DDS::DataReader_var CreateDataReader(DDS::Subscriber_ptr sub, DDS::TopicDescription_ptr topic);
    DDS::DataWriter_var CreateDataWriter(DDS::Publisher_ptr pub, DDS::Topic_ptr topic);
public:
    virtual ~DDSMPIBase() {}
    virtual void Initialize(int &argc, ACE_TCHAR *argv[]) = 0;
    virtual void Shutdown() = 0;
    virtual void Send(void *buf, int count, int dest, int tag) = 0;
    virtual void Recv(void *buf, int count, int source, int tag, int &actualSource, int &actualTag) = 0;
    virtual int GetRank() const { return _rank; }
    virtual int GetSize() const { return _size; }
    virtual std::string GetType() const = 0;
};


#define DDSMPI_BROADCAST -1
#define DDSMPI_ANY_SOURCE -1
#define DDSMPI_ANY_TAG -1

void DDSMPILib_Export DDSInitialize(int argc, ACE_TCHAR *argv[]);
void DDSMPILib_Export DDSShutdown();

#endif
