#include <mpi.h>
#include <assert.h>

int main(int argc, char *argv[]) {
    int size, rank;
    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    MPI_Status status;
    if (rank==0) {
        int i = 1, j = 0;  // initially 1 for the master
        MPI_Send(&i, 1, MPI_INT, 1, 99, MPI_COMM_WORLD);
        MPI_Recv(&j, 1, MPI_INT, size-1, 99, MPI_COMM_WORLD, &status);
        assert(j == size);
    }
    else {
        int i = 0;
        MPI_Recv(&i, 1, MPI_INT, rank-1, 99, MPI_COMM_WORLD, &status);
        i++;  // +1 for the worker
        MPI_Send(&i, 1, MPI_INT, (rank+1)%size, 99, MPI_COMM_WORLD);
    }

    MPI_Finalize();
    return 0;
}
