#include <mpi.h>
#include <iostream>

// to prove that messages, matching by tag, can be accepted in any order (not order that they were received)

int main(int argc, char *argv[]) {
    int size, rank;
    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    MPI_Status status;
    int i = 0;
    if (rank == 0) {
        // send 19 first, then 99
        std::cout << "send 19" << std::endl;
        MPI_Send(&i, 1, MPI_INT, 1, 19, MPI_COMM_WORLD);
        std::cout << "send 99" << std::endl;
        MPI_Send(&i, 1, MPI_INT, 1, 99, MPI_COMM_WORLD);
        MPI_Recv(&i, 1, MPI_INT, 1, 99, MPI_COMM_WORLD, &status);
        std::cout << "receive 99" << std::endl;
        MPI_Recv(&i, 1, MPI_INT, 1, 19, MPI_COMM_WORLD, &status);
        std::cout << "receive 19" << std::endl;
    }
    else if (rank == 1) {
        MPI_Recv(&i, 1, MPI_INT, 0, 99, MPI_COMM_WORLD, &status);
        MPI_Send(&i, 1, MPI_INT, 0, 99, MPI_COMM_WORLD);

        // to prove that messages can be received out of order 
        // if order enforced, then tag 19 msg has to be read before tag 99 msg
        MPI_Recv(&i, 1, MPI_INT, 0, 19, MPI_COMM_WORLD, &status);
        MPI_Send(&i, 1, MPI_INT, 0, 19, MPI_COMM_WORLD);
    }

    MPI_Finalize();
    return 0;
}
